;  "256 Color Program"
;  By Jerry Burianyk
;  CURSOR 2, no. 5 (January/February 1980): 87-87.
;
;  For Bally Arcade/Astrocade
;  Modified by Andy Guevara in 1982 for use with "Machine Language
;  Manager" cartridge. 
;
;  This version of "256 Color Program" is from the "Machine Language
;  Manager" manual, page 7-5.  This is a modified version of the
;  program submitted by Jerry Burianyk in the Jan/Feb '91 issue of
;  CURSOR.  Turn KN(1) to change the number of displayed colors.  To
;  restore the screen, hit RESET, CALL, and four WRITES.
;
;  Version History:
;    .01 (July 30, 2013)
;       - Re-typed and Assembled by Adam Trionfo
;
;  To assemble this Z-80 source code using ZMAC:
;  
;     zmac -d -o <outfile> -x <listfile> <filename>
;  
;  For example, assemble this Astrocade Z-80 ROM file:
;     
;     zmac -i -m -o 256color.bin -x 256color.lst 256color.z80 
;

;  Equates

CLEAR   EQU     $2347           ; "MLM" "clear screen" routine

        ORG     $4EF5

L4EF5:  DI                      ;
        PUSH    AF
        LD      A,$4F           ; Load screen interrupt vector
        LD      I,A             ;    with $4F10
        LD      A,$10
        OUT     ($0D),A
        CALL    CLEAR           ; Clear screen
        LD      A,$FF           ; Set interrupt line
        OUT     ($0F),A         ; To 256
        LD      A,$12           ; Set right/left boundary
        OUT     ($09),A         ;    to middle of screen
        POP     AF
        EI
        RET

        NOP                     ; Take up three bytes to
        NOP                     ;    even things up with
        NOP                     ;    printed program
                
L4F10:  DW      $4F12           ; Address of interrupt routine

L4F12:  DI
        PUSH    AF
        PUSH    DE
        IN      A,($1C)         ; Get KN(1) value
L4F17:  OUT     ($00),A         ; Send to Color
        OUT     ($01),A         ;    ports 0-3
        OUT     ($02),A
        OUT     ($03),A
        DEC     A               ; Decrement KN(1) value
        JR      NZ,L4F17        ; Count KN(1) value to zero
        POP     DE              ; Clean up, go home
        POP     AF          
        EI
L4F25:  RET
        
END                             ; End of Program        